FUNCTION_BLOCK FB_limits_verification
VAR_INPUT
PointNR					: INT ;
END_VAR

VAR_OUTPUT
PointValue_Changed		: BOOL ;
END_VAR
PointValue_Changed:=FALSE ;

CASE PointNR OF 
	36: IF 		(ProgramValues[PointNR] <   0.0) THEN 									(* Heating_Coil_Valve_Manual_Control (sec)						*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 100.0) THEN
			ProgramValues[PointNR]:=100.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	37: IF 		(ProgramValues[PointNR] <   0.0) THEN 									(* Cooling_Coil_Valve_Manual_Control (sec)						*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 100.0) THEN
			ProgramValues[PointNR]:=100.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	38: IF 		(ProgramValues[PointNR] <  10.0) THEN 									(* Damper_Opening_Delay (sec)			 						*)
			ProgramValues[PointNR]:=10.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 300.0) THEN
			ProgramValues[PointNR]:=300.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	39: IF 		(ProgramValues[PointNR] <  10.0) THEN 									(* Fan_Conflict_Delay (sec)			 							*)
			ProgramValues[PointNR]:=10.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 300.0) THEN
			ProgramValues[PointNR]:=300.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	40: IF 		(ProgramValues[PointNR] < 200.0) THEN 									(* Return_Air_CO2_Setpoint (ppm) 			 					*)
			ProgramValues[PointNR]:=200.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] >1500.0) THEN
			ProgramValues[PointNR]:=1500.0; 	PointValue_Changed:=TRUE; 
		END_IF;		
	41: IF 		(ProgramValues[PointNR] < 150.0) THEN 									(* Return_Air_Temperature_Setpoint (x10 °C) 					*)
			ProgramValues[PointNR]:=150.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 300.0) THEN
			ProgramValues[PointNR]:=300.0; 		PointValue_Changed:=TRUE; 
		END_IF;		
	42: IF 		(ProgramValues[PointNR] < 150.0) THEN 									(* Supply_Air_Temperature_Setpoint_Minimum (x10 °C) 			*)
			ProgramValues[PointNR]:=150.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 250.0) THEN
			ProgramValues[PointNR]:=250.0; 		PointValue_Changed:=TRUE; 
		END_IF;		
	43: IF ProgramValues[PointNR]<ProgramValues[42] THEN								(* maximum has to be bigger than minimum 						*)
			ProgramValues[PointNR] := ProgramValues[42] + 1.0 ;
			PointValue_Changed:=TRUE;
		END_IF ;
		IF 		(ProgramValues[PointNR] < 200.0) THEN 									(* Supply_Air_Temperature_Setpoint_Maximum (x10 °C) 			*)
			ProgramValues[PointNR]:=200.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 300.0) THEN
			ProgramValues[PointNR]:=300.0; 		PointValue_Changed:=TRUE; 
		END_IF;		
	44: IF 		(ProgramValues[PointNR] <  10.0) THEN 									(* Supply_Air_Temperature_Setpoint_Deviation_Limit (x10 °C) 	*)
			ProgramValues[PointNR]:=10.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 150.0) THEN
			ProgramValues[PointNR]:=150.0; 		PointValue_Changed:=TRUE; 
		END_IF;			
	45: IF 		(ProgramValues[PointNR] < 30.0) THEN 									(* Heating_Coil_Return_Water_Temperature_Alarm_Limit (x10 °C)	*)
			ProgramValues[PointNR]:=30.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 250.0) THEN
			ProgramValues[PointNR]:=250.0; 		PointValue_Changed:=TRUE; 
		END_IF;		
	46: IF 		(ProgramValues[PointNR] < 30.0) THEN 									(* Heating_Coil_Return_Water_Temperature_Safety_P_Band (x10 °C)	*)
			ProgramValues[PointNR]:=30.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 250.0) THEN
			ProgramValues[PointNR]:=250.0; 		PointValue_Changed:=TRUE; 
		END_IF;		
	47: IF 		(ProgramValues[PointNR] <    0.0) THEN 									(* Fans_Minimum_Start_Speed (minimum speed)(%)	 				*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] > 100.0) THEN
			ProgramValues[PointNR]:=100.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	48: IF 		(ProgramValues[PointNR] <    0.0) THEN 									(* Manual operation button				 						*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] >   2.0) THEN
			ProgramValues[PointNR]:=2.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	49: IF 		(ProgramValues[PointNR] <    0.0) THEN 									(* Fire alarm input				 								*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		ELSIF 	(ProgramValues[PointNR] >   1.0) THEN
			ProgramValues[PointNR]:=1.0; 		PointValue_Changed:=TRUE; 
		END_IF;
	50: IF (ProgramValues[PointNR]<>0.0) AND (ProgramValues[PointNR]<>1.0) AND (ProgramValues[PointNR]<>17.0) THEN 		(* "Reset Alarm" button 		*)
			ProgramValues[PointNR]:=0.0; 		PointValue_Changed:=TRUE; 
		END_IF;
END_CASE; 
END_FUNCTION_BLOCK